PRAGMA yt.InferSchema;

USE hahn;

$MOSCOW_OFFSET = 3 * 60 * 60;

$utms24 = Yson::ConvertToDict(Yson::ParseJson(utms24h));

INSERT INTO
    $output_path
WITH TRUNCATE

SELECT
    fielddate || ':00:00' AS fielddate,
    partner,
    pp,
    utm_source24,
    utm_medium24,
    utm_content24,
    COUNT(*) AS count
FROM RANGE(
    [home/avia/logs/avia-json-redirect-error-log],
    $start_date,
    $end_date
)
GROUP BY
    DateTime::ToStringFormat(
        DateTime::TimestampFromSeconds(CAST(unixtime AS UInt64)),
        '%Y-%m-%d %H'
    ) AS fielddate,
    partner,
    CAST(pp AS Int32) AS pp,
    Yson::ConvertToString($utms24{'utm_source'}) ?? '__empty__' AS utm_source24,
    Yson::ConvertToString($utms24{'utm_medium'}) ?? '__empty__' AS utm_medium24,
    Yson::ConvertToString($utms24{'utm_content'}) ?? '__empty__' AS utm_content24;
