USE hahn;

$utms24 = Yson::ConvertToDict(utms24h);

INSERT INTO
    $output_path
WITH TRUNCATE

SELECT
    fielddate || ':00:00' AS fielddate,
    billing_client_id,
    pp,
    utm_source24,
    utm_medium24,
    utm_content24,
    COUNT(*) AS n_redirects
FROM RANGE(
    [home/avia/logs/avia-json-redir-log],
    $start_date,
    $end_date
)
GROUP BY
    DateTime::ToStringFormat(
        DateTime::TimestampFromSeconds(unixtime),
        '%Y-%m-%d %H'
    ) AS fielddate,
    billing_client_id,
    pp,
    Yson::ConvertToString($utms24{'utm_source'}) ?? '__empty__' AS utm_source24,
    Yson::ConvertToString($utms24{'utm_medium'}) ?? '__empty__' AS utm_medium24,
    Yson::ConvertToString($utms24{'utm_content'}) ?? '__empty__' AS utm_content24;
