USE hahn;
DECLARE $start_date AS String;
DECLARE $end_date AS String;

$unpacked = (
SELECT
    segment, national_version
FROM RANGE(`logs/avia-action-show-log/1d`, $start_date, $end_date)
FLATTEN LIST BY (String::SplitToList(forward, ',') as segment)
    UNION ALL
SELECT
    segment, national_version
FROM RANGE(`logs/avia-action-show-log/1d`, $start_date, $end_date)
FLATTEN LIST BY (String::SplitToList(backward, ',') as segment)
);

$companies_on_front = (SELECT
    String::SplitToList(segment, ' ')[0] AS code, national_version
FROM $unpacked);

SELECT COUNT(code) AS cnt, code
FROM $companies_on_front
WHERE national_version NOT IN ('com', 'ua') AND code != ''
GROUP BY code
ORDER BY cnt DESC;
