# -*- encoding: utf-8 -*-


def main():
    import travel.avia.admin.init_project  # noqa

    import logging
    import sys
    from optparse import OptionParser

    from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log
    from travel.avia.admin.lib.exporters_for_stat_admin import avia_stats_settlement_exporter

    log = logging.getLogger(__name__)
    create_current_file_run_log()

    option_parser = OptionParser()
    option_parser.add_option('-v', '--verbose', action='store_true')

    options, args = option_parser.parse_args()

    if options.verbose:
        print_log_to_stdout()

    log.info('Start')
    has_error = avia_stats_settlement_exporter.export()
    if has_error:
        log.error('Exit')
        sys.exit(1)
    log.info('End')
