# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

from django.db import transaction

from travel.avia.library.python.common.models.partner import Partner, RegionalizePartnerQueryRule
from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.library.python.route_search.models import ZNodeRoute2

log = logging.getLogger(__name__)


@transaction.atomic
def store_rules(amadeus_routes):
    partner = Partner.objects.get(code='amadeus')
    RegionalizePartnerQueryRule.objects.filter(partner=partner).delete()

    for settlement_from, settlement_to in amadeus_routes:
        queryrule = RegionalizePartnerQueryRule(
            partner=partner,
            settlement_from=settlement_from,
            country_from=settlement_from.country,
            settlement_to=settlement_to,
            country_to=settlement_to.country,
        )

        queryrule.save()


def make_routes():
    amadeus_routes = set()

    znoderoutes = ZNodeRoute2.objects.filter(
        thread__t_type__code='plane',
        thread__number__startswith='U6 '
    )

    for znoderoute in znoderoutes:
        amadeus_routes.add((znoderoute.settlement_from, znoderoute.settlement_to))
        amadeus_routes.add((znoderoute.settlement_to, znoderoute.settlement_from))

    return amadeus_routes


def _main():
    log.info(u'Start import')

    log.info('Make routes')
    amadeus_routes = make_routes()

    log.info('Store routes')
    store_rules(amadeus_routes)

    log.info('%s rules saved', len(amadeus_routes))
    log.info(u'Done')


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
