# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

import requests

from django.db import transaction

from travel.avia.admin.lib.settlement_cache import get_settlement
from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.library.python.common.models.partner import Partner, RegionalizePartnerQueryRule
from travel.avia.library.python.common.utils.safe_xml_parser import safe_xml_fromstring

ROUTES_URL = 'http://www.clickavia.ru/search/routes'

log = logging.getLogger(__name__)


def get_routes():
    r = requests.get(
        ROUTES_URL,
    )

    return r.content


def parse_xml(xml):
    routes = set()
    tree = safe_xml_fromstring(xml)

    for dc in tree.xpath('//routes/departure_country/departure_city'):
        for ac in dc.xpath('arrival_country/arrival_city'):
            settlement_from = get_settlement(dc.get('iata'))
            settlement_to = get_settlement(ac.get('iata'))

            if settlement_from and settlement_to:
                routes.add((settlement_from, settlement_to))

    return routes


@transaction.atomic
def update_routes(routes):
    partner = Partner.objects.get(code='clickavia')
    partner.regionalizepartnerqueryrule_set.all().delete()

    for settlement_from, settlement_to in routes:
        queryrule = RegionalizePartnerQueryRule(
            partner=partner,
            settlement_from=settlement_from,
            country_from=settlement_from.country,
            settlement_to=settlement_to,
            country_to=settlement_to.country,
        )

        queryrule.save()


# FIXME: Exceptions
def _main():
    log.info(u'Start import')

    log.info(u'Get xml from %s', ROUTES_URL)
    xml = get_routes()

    log.info(u'Parse xml')
    routes = parse_xml(xml)

    log.info(u'Store %s routes', len(routes))
    update_routes(routes)

    log.info(u'Done')


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
