# -*- coding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
import csv
import urllib2

from cachetools.func import lru_cache
from django.db import transaction
from django.db.models import Q

from travel.avia.library.python.common.models.partner import Partner, RegionalizePartnerQueryRule
from travel.avia.library.python.common.models.geo import Settlement, StationCode

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log

log = logging.getLogger(__name__)

MOIREIS_URL = 'https://www.moireis.ru/gate/csv/yandex.csv'


@lru_cache(maxsize=None)
def get_settlement(iata):
    settlement = None

    try:
        settlement = Settlement.objects.get(iata=iata)

    except Settlement.DoesNotExist:
        pass

    if not settlement:
        try:
            station = StationCode.objects.get(
                Q(system__code__iexact='iata') | Q(system__code__iexact='sirena'),
                code__iexact=iata
            )
            settlement = station.station.settlement

        except StationCode.DoesNotExist:
            pass

    return settlement


@transaction.atomic
def update_rules(partner):
    partner.regionalizepartnerqueryrule_set.all().delete()

    response = urllib2.urlopen(MOIREIS_URL)
    r = csv.reader(response, delimiter=';')
    for from_iata, to_iata in r:
        log.info('From "%s" to "%s"', from_iata, to_iata)

        from_settlement = get_settlement(from_iata)
        to_settlement = get_settlement(to_iata)

        regionalize_partner_query_rule = RegionalizePartnerQueryRule(
            settlement_from=from_settlement,
            settlement_to=to_settlement,
            country_from=from_settlement.country,
            country_to=to_settlement.country,
            partner=partner,
        )

        regionalize_partner_query_rule.save()


def _main():
    log.info(u'Start import white list')

    try:
        partner = Partner.objects.get(code='moireis')
        update_rules(partner)
    except Exception:
        log.exception('Moireis fetch error')

    log.info(u'Done')


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
