# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

from django.db import transaction

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.admin.lib.settlement_cache import get_settlement
from travel.avia.library.python.common.models.partner import Partner, RegionalizePartnerQueryRule
from travel.avia.library.python.sirena_client.django import sirena_client_factory


log = logging.getLogger(__name__)

CLIENT_ID = 2979
COMPANY_CODE = 'WZ'
LANG = 'en'


@transaction.atomic
def update_routes(routes):
    partner = Partner.objects.get(code='redwings')
    partner.regionalizepartnerqueryrule_set.all().delete()

    for code_from, codes_to in routes.items():
        settlement_from = get_settlement(code_from)
        for code_to in codes_to:
            settlement_to = get_settlement(code_to)
            try:
                queryrule = RegionalizePartnerQueryRule(
                    partner=partner,
                    settlement_from=settlement_from,
                    country_from=settlement_from.country,
                    settlement_to=settlement_to,
                    country_to=settlement_to.country,
                )
                queryrule.save()
            except Exception as err:
                log.exception(u'%s %s %s', code_from, code_to, err)


def _main():
    log.info(u'Start import')

    factory = sirena_client_factory(CLIENT_ID)
    success = False
    client = factory()
    while client:
        try:
            log.info(u'Get data %s', client._host)
            routes = client.get_company_routes(COMPANY_CODE, LANG)

            log.info(u'Store %s routes', len(routes))
            log.info(routes)

            update_routes(routes)
            success = True
            break
        except Exception as e:
            log.exception(e)
            client = factory()

    if success:
        log.info(u'Done')
    else:
        raise Exception(u'All requests failed')


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
