# -*- encoding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

import requests
from django.conf import settings
from travel.avia.admin.www.models import Setting
from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log

log = logging.getLogger(__name__)


def _main():
    url = '%s/3.0/cities' % getattr(settings, 'TAXI_BACKEND_HOST', 'https://tc.mobile.yandex.net')

    try:
        r = requests.post(url, data='{}', headers={'Content-Type': 'application/json'})
    except Exception as e:
        log.error('Cannot fetch taxi cities: %s', repr(e))

    try:
        geoids = [unicode(city['geo_id']) for city in r.json()]
    except Exception as e:
        log.error('Wrong response taxi cities: %s', repr(e))

    try:
        taxi_setting = Setting.objects.get(code='TAXI_GEOIDS')
    except Setting.DoesNotExist:
        taxi_setting = Setting(
            code='TAXI_GEOIDS',
            type='str',
            name=u'Geoid городов в которых работает яндекс.такси'
        )

    taxi_setting.value = u','.join(geoids)
    taxi_setting.save()


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
