# -*- coding: utf-8 -*-

import travel.avia.admin.init_project  # noqa

import logging

import requests

from django.db import transaction
from django.conf import settings

from travel.avia.admin.avia.models import ToursMatrix

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log

log = logging.getLogger(__name__)


TOURS_BASE_URL = 'http://%s:%d' % (settings.TOURS_HOST, settings.TOURS_PORT)


@transaction.atomic
def load_matrix():
    r = requests.get(
        '%s/api/1.x/reference/destinations' % TOURS_BASE_URL,
        timeout=60  # ручка может долго отвечать
    )
    r.raise_for_status()

    bulk = []

    for from_geo_id, to_geo_ids in r.json()['data'][0].iteritems():
        for to_geo_id in to_geo_ids:
            item = ToursMatrix(from_geo_id=int(from_geo_id), to_geo_id=to_geo_id)
            bulk.append(item)

    ToursMatrix.objects.all().delete()
    ToursMatrix.objects.bulk_create(bulk, batch_size=1000)
    log.info('created %d directions', len(bulk))


def _main():
    log.info(u'Start import')

    try:
        load_matrix()

    except Exception:
        log.exception(u'fetch error')

    log.info(u'Done')


def main():
    from optparse import OptionParser

    optparser = OptionParser()
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    create_current_file_run_log()

    _main()
