# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
import os
import sys

from optparse import OptionParser

from django.db import transaction
from library.python import resource

from travel.avia.library.python.avia_data.models.review import FlightReview, FlightNumber
from travel.avia.library.python.common.models.schedule import Company
from travel.avia.admin.lib.logs import print_log_to_stdout, create_current_file_run_log

log = logging.getLogger(__name__)


# Это временный скрипт для _разовой_ заливки данных из бд рассписаний
# Очень не хотелось возиться с data-миграцией
# Снести после https://st.yandex-team.ru/RASPTICKETS-4415
@transaction.atomic
def _main(options):
    data_file_name = os.path.join('resfs/file', os.path.dirname(__file__), 'data/flight_numbers.data.txt')

    data = resource.find(data_file_name)
    fake_add_str = ' fake' if options.fake else ''
    for data_item in data.split(';'):
        review_id, airline_code, flight_number = data_item.split('_')
        airline = Company.objects.get(iata=airline_code)
        full_flight_number = u'%s %s' % (airline.iata, flight_number.split(' ')[-1])
        try:
            r = FlightReview.objects.get(review_id=review_id)

        except FlightReview.DoesNotExist:
            log.info(u'DoesNotExist review_id: %s', review_id)
            continue

        except FlightReview.MultipleObjectsReturned:
            log.info(u'MultipleObjectsReturned review_id: %s', review_id)
            continue

        fn, created = FlightNumber.objects.get_or_create(
            airline=airline,
            flight_number=full_flight_number,
        )

        log.info(u'review_id: %s,%s add: %s', r.id, fake_add_str, full_flight_number)

        if not options.fake:
            r.flight_numbers.add(fn)
            r.save()


def main():
    optparser = OptionParser()
    optparser.add_option('--fake', action='store_true')
    optparser.add_option('--sure', action='store_true')
    options, args = optparser.parse_args()
    print_log_to_stdout(log)

    create_current_file_run_log()

    if not options.sure:
        log.info('Are you sure?')
        sys.exit(0)

    _main(options)
