# coding: utf-8

import travel.avia.admin.init_project  # noqa

import argparse
import logging

from travel.avia.library.python.common.models.partner import Partner

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.admin.lib.partner_mail_sender import send_mail, STATISTIC_REMINDER_NOTIFICATION_MAIL_TYPE

log = logging.getLogger(__name__)


def send_notifications(partners, force=False):
    log.info('Start')
    log.info('Enabled avia-partners: %s', ', '.join(p.code for p in partners))

    for partner in partners:
        send_mail(partner, STATISTIC_REMINDER_NOTIFICATION_MAIL_TYPE)

    log.info('End')


def main():
    create_current_file_run_log()

    parser = argparse.ArgumentParser(description='Process some integers.')
    parser.add_argument('--force', action="store_true")
    parser.add_argument('-v', '--verbose', action='store_true')
    args = parser.parse_args()

    if args.verbose:
        add_stdout_handler(log)
    force = args.force

    partners = sorted(
        Partner.objects.filter(t_type__code='plane', disabled=False),
        key=lambda x: x.code
    )
    send_notifications(partners, force=force)
