import travel.avia.admin.init_project  # noqa

import argparse
import logging
from datetime import datetime, timedelta

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.admin.lib.yt_helpers import yt_client_fabric

logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--path')
    parser.add_argument('--days', type=int)
    parser.add_argument('--verbose', action='store_true')

    return parser.parse_args()


def remove_old_logs(yt_client, path, days):
    logger.info('Removing tables form %s which are older than %d days', path, days)
    left_border = (datetime.today() - timedelta(days=days)).strftime('%Y-%m-%d')

    path_filter = lambda table_path: table_path.split('/')[-1] < left_border
    removed = 0
    for table in yt_client.search(path, node_type='table', path_filter=path_filter):
        logger.info('Remove table %s', table)
        yt_client.remove(table)
        removed += 1

    logger.info('%d tables was removed', removed)


def main():
    args = parse_args()
    create_current_file_run_log()

    if args.verbose:
        add_stdout_handler(logger)

    logger.info('Start')
    remove_old_logs(yt_client_fabric.create(), args.path, args.days)
    logger.info('End')
