# coding: utf8
from logging import getLogger
from travel.avia.library.python.common.models.schedule import Company

log = getLogger(__name__)


def main():
    company_model_qs = Company.objects.exclude(svg_logo2=None).exclude(svg_logo2='')
    log.info('Need update %s companies', company_model_qs.count())

    for company in company_model_qs:
        update_company_logo(company)

    log.info('finish')


def update_company_logo(company):
    old = company.svg2png_logo2
    company.svg2png_logo2 = ''
    company.save(update_fields=('svg2png_logo2',))
    log.info('Update company %s old svg2png_logo2 %s', company, old)
