# -*- encoding: utf-8 -*-
import travel.avia.admin.init_project  # noqa

import logging
from copy import copy
from optparse import Option, OptionParser

from django.db import connection, transaction

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType


def main():
    log = logging.getLogger(__name__)
    create_current_file_run_log()

    optparser = OptionParser(option_class=Yoption)
    optparser.add_option('-v', '--verbose', action='store_true')
    options, args = optparser.parse_args()

    if options.verbose:
        add_stdout_handler(log)

    log.info('Start')

    try:
        company_data = iter_protobuf_data(ResourceType.TRAVEL_DICT_RASP_CARRIER_PROD)
        update_company_ids(company_data, log)

    except Exception as e:
        log.exception('ERROR: %s', e.message)


@transaction.atomic()
def update_company_ids(company_data, log):
    log.info('Start updating ids')
    cursor = connection.cursor()
    processed_count = 0
    for company in company_data:
        sync_company_id(company, cursor, log)
        processed_count += 1
        if processed_count % 100 == 0:
            log.info('Processed {} entries'.format(processed_count))
    cursor.close()

    log.info('Done updating ids. %s protobuf entries processed', processed_count)


def sync_company_id(company, cursor, log):
    if not company.Title:
        return
    # first try to use iata - it is most reliable "identifier" in real world
    # (actually it is not identifier at all -  because it is not unique)
    if company.Iata:
        cursor.execute('SELECT count(*) FROM www_company where iata = %s', [company.Iata])
        count = cursor.fetchone()[0]
        if count == 1:
            cursor.execute('UPDATE www_company SET id = %s WHERE id != %s and iata=%s', [company.Id, company.Id,
                           company.Iata])
            return
        # iata is not unique in database - now we try pair (iata, title)
        if count > 1:
            cursor.execute('SELECT count(*) FROM www_company where iata = %s and title = %s', [company.Iata,
                           company.Title])
            count = cursor.fetchone()[0]
            if count == 1:
                cursor.execute('UPDATE www_company SET id = %s WHERE id != %s and iata=%s and title=%s', [company.Id,
                               company.Id,
                               company.Iata, company.Title])
                return
            elif count > 1:
                log.error('Multiple rows with same (iata, title) are found in database: (%s, %s)', company.Iata,
                          company.Title)
                return

                # if we get this far then iata matching failed
    if company.Icao:
        # icao is unique, no need to fetch count
        cursor.execute('UPDATE www_company SET id = %s WHERE id != %s and icao=%s', [company.Id, company.Id,
                       company.Icao])
        return

    # try sirena as a last resort
    if company.SirenaId:
        cursor.execute('UPDATE www_company SET id = %s WHERE id != %s and sirena_id=%s', [company.Id, company.Id,
                       company.SirenaId])
        return

    # now all we have is a title
    cursor.execute('SELECT count(*) FROM www_company where title = %s', [company.Title])
    count = cursor.fetchone()[0]
    if count == 1:
        cursor.execute('UPDATE www_company SET id = %s WHERE id != %s and title=%s', [company.Id, company.Id,
                       company.Title])
        return
    if count > 1:
        log.error('Multiple rows with same title are found in database: %s', company.Title)
        return
    if count == 0:
        log.warn('Company with id %s has no match in database', company.Id)


class Yoption(Option):
    TYPES = Option.TYPES
    TYPE_CHECKER = copy(Option.TYPE_CHECKER)
