# coding: utf-8
from __future__ import unicode_literals, print_function, division

import travel.avia.admin.init_project  # noqa

import argparse
import logging

from django.conf import settings

from travel.avia.library.python.common.models.schedule import AviaAlliance
from travel.avia.library.python.common.models.translations import TranslatedTitle, TranslatedText
from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log
from travel.avia.library.python.shared_dicts.rasp import iter_protobuf_data, ResourceType

log = logging.getLogger(__name__)


def sync_aviaalliance(rasp_aviaalliance_data):
    _log_deleted_aviaalliance(rasp_aviaalliance_data)
    _update_aviaalliance(rasp_aviaalliance_data)


def _log_deleted_aviaalliance(rasp_aviaalliance_data):
    db_ids = set(AviaAlliance.objects.all().values_list('id', flat=True))
    rasp_ids = {c.Id for c in rasp_aviaalliance_data}
    deleted_ids = db_ids - rasp_ids
    if not deleted_ids:
        log.info('No deleted avia alliances')
    else:
        for aviaalliance in AviaAlliance.objects.filter(id__in=deleted_ids):
            log.warning('%s was deleted in rasp', _aviaalliance_to_text(aviaalliance))


def _update_aviaalliance(rasp_aviaalliance_data):
    db_ids = set(AviaAlliance.objects.all().values_list('id', flat=True))

    for rasp_aviaalliance in rasp_aviaalliance_data:
        if rasp_aviaalliance.Id not in db_ids:
            L_title = TranslatedTitle()
            L_description = TranslatedText()
            L_title.save()
            L_description.save()
            aviaalliance, created = AviaAlliance.objects.get_or_create(
                id=rasp_aviaalliance.Id,
                defaults={
                    'logo_svg': rasp_aviaalliance.LogoSvg,
                    'enabled': rasp_aviaalliance.Enabled,
                    'title': rasp_aviaalliance.TitleDefault,
                    'title_ru': rasp_aviaalliance.Title.Ru,
                    'title_en': rasp_aviaalliance.Title.En,
                    'title_uk': rasp_aviaalliance.Title.Uk,
                    'title_tr': rasp_aviaalliance.Title.Tr,
                    'description': rasp_aviaalliance.DescriptionDefault,
                    'description_ru': rasp_aviaalliance.Description.Ru,
                    'description_en': rasp_aviaalliance.Description.En,
                    'description_uk': rasp_aviaalliance.Description.Uk,
                    'description_tr': rasp_aviaalliance.Description.Tr,
                    'new_L_title': L_title,
                    'new_L_description': L_description,
                }
            )
            aviaalliance.save()
            log.info('New aviaalliance %s', _aviaalliance_to_text(aviaalliance))
        else:
            AviaAlliance.objects.filter(id=rasp_aviaalliance.Id).update(**{
                'logo_svg': rasp_aviaalliance.LogoSvg,
                'enabled': rasp_aviaalliance.Enabled,
                'title': rasp_aviaalliance.TitleDefault,
                'title_ru': rasp_aviaalliance.Title.Ru,
                'title_en': rasp_aviaalliance.Title.En,
                'title_uk': rasp_aviaalliance.Title.Uk,
                'title_tr': rasp_aviaalliance.Title.Tr,
                'description': rasp_aviaalliance.DescriptionDefault,
                'description_ru': rasp_aviaalliance.Description.Ru,
                'description_en': rasp_aviaalliance.Description.En,
                'description_uk': rasp_aviaalliance.Description.Uk,
                'description_tr': rasp_aviaalliance.Description.Tr,
            })
            aviaalliance = AviaAlliance.objects.get(id=rasp_aviaalliance.Id)

        aviaalliance.new_L_title.ru_nominative = rasp_aviaalliance.Title.Ru
        aviaalliance.new_L_title.en_nominative = rasp_aviaalliance.Title.En
        aviaalliance.new_L_title.tr_nominative = rasp_aviaalliance.Title.Tr
        aviaalliance.new_L_title.uk_nominative = rasp_aviaalliance.Title.Uk
        aviaalliance.new_L_title.save()

        aviaalliance.new_L_description.ru = rasp_aviaalliance.Description.Ru
        aviaalliance.new_L_description.en = rasp_aviaalliance.Description.En
        aviaalliance.new_L_description.tr = rasp_aviaalliance.Description.Tr
        aviaalliance.new_L_description.uk = rasp_aviaalliance.Description.Uk
        aviaalliance.new_L_description.save()

        aviaalliance.save()


def _aviaalliance_to_text(aviaalliance):
    return 'AviaAlliance id={aviaalliance.id}, title="{aviaalliance.title}"'.format(aviaalliance=aviaalliance)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--verbose', action='store_true')
    args = parser.parse_args()

    if args.verbose:
        add_stdout_handler(log)
    create_current_file_run_log()

    log.info('Start sync www_aviaalliance')

    try:
        do_sync()
    except Exception:
        log.exception('Error in sync www_aviaalliance')
        raise
    else:
        log.info('Successfully sync www_aviaalliance')


def do_sync():
    rasp_aviaalliance_data = list(iter_protobuf_data(
        ResourceType.TRAVEL_DICT_RASP_AVIAALLIANCE_PROD,
        oauth=settings.SANDBOX_OAUTH_TOKEN or None,
    ))
    sync_aviaalliance(rasp_aviaalliance_data)
