PRAGMA yt.InferSchema = '1';
USE hahn;
DECLARE $cache_table as STRING;

$partners = AsList('superkassa', 'biletix', 'kupibilet', 'uzairways', 'ozon', 'megotravel', 'ticketsru', 'aviakass', 'svyaznoy');

$depthInterval = ($depth) -> {
    RETURN (
      CASE WHEN $depth < 14 THEN CAST($depth as String)
      WHEN 14 <= $depth and $depth < 21 THEN '14-21'
      WHEN 21 <= $depth and $depth < 28 THEN '21-28'
      WHEN 28 <= $depth and $depth < 35 THEN '28-35'
      WHEN 35 <= $depth and $depth < 42 THEN '35-42'
      WHEN 42 <= $depth and $depth < 49 THEN '42-49'
      WHEN 49 <= $depth and $depth < 56 THEN '49-56'
      WHEN 56 <= $depth and $depth < 63 THEN '56-63'
      ELSE '63+' END
    );
};


$queries = (SELECT  depth, count (1) as c
FROM range( `//home/rasp/logs/rasp-partners-query-log`, `2020-01-01`, `2020-03-18`)
where  status='got_reply' and variants_len>'0' and String::SplitToList(String::SplitToList(qid,".")[3],"_")[8] = "ru" and
String::SplitToList (importer, "[]", false)[1] in $partners
group by (
    $depthInterval(CAST(DateTime::ToDays((CAST(String::SplitToList(String::SplitToList(qid,".")[3],"_")[2] as Date)-CAST(SUBSTRING(iso_eventtime,0,10) as Date))) as Int32)) as depth
 )
);

$redirs = (SELECT depth, count(1) as c
from range(`//home/avia/logs/avia-redir-balance-by-day-log`,`2020-01-01`, `2020-03-18`)
where NATIONAL_VERSION = "ru" and FILTER=0 and PARTNERCODE in $partners
group by $depthInterval(CAST(DateTime::ToDays(CAST(`WHEN` as Date)-CAST(SUBSTRING(ISO_EVENTTIME,0,10) as Date)) as Int32)) as depth
);


$books = (SELECT depth, count(DISTINCT b.order_id) as c
from range(`//home/avia/logs/avia-partner-booking-log`,`2020-01-01`, `2020-03-18`) as b
join range(`//home/avia/logs/avia-redir-balance-by-day-log`, `2020-01-01`, `2020-03-18`) as r
on r.MARKER=b.marker
where   b.status = "paid" and r.NATIONAL_VERSION = "ru" and r.FILTER=0 and b.partner in $partners
group by $depthInterval(CAST(DateTime::ToDays(CAST(`WHEN` as Date)-CAST(SUBSTRING(ISO_EVENTTIME,0,10) as Date)) as Int32)) as depth
);



INSERT INTO
    $cache_table
WITH TRUNCATE
SELECT q.depth as depth, CAST(b.c*1.0/r.c*1.0 as Double) as book2redir,  CAST(q.c*1.0/b.c*1.0 as Double) / ListLength($partners) as look2book, q.c as queries_count, b.c / 77 / ListLength($partners) as books_count
from $queries as q
join $redirs as r
on q.depth = r.depth
join $books as b
on r.depth = b.depth
