USE hahn;
DECLARE $day_count AS INT;
DECLARE $start_day as DATE;
DECLARE $cache_table as STRING;

$range = ListFromRange(1, $day_count);

$shift_forward_by_days = ($days_count) -> {
    RETURN Unwrap(
        $start_day + $days_count * Interval("P1D"),
        "Failed to shift start_day back by " || CAST($days_count AS String) || " days"
    );
};
$dates = ListMap($range, $shift_forward_by_days);

DEFINE ACTION $check_one_day($date) AS $current_date = CAST($date AS String);
    $user_search = "home/avia/logs/avia-users-search-log/" || $current_date;
    $wizrd_search = "home/logfeller/logs/avia-wizard-query-log/1d/" || $current_date;
    $rasp_search = "home/rasp/logs/rasp-users-search-log/" || $current_date;
    $rasp_search = (SELECT * FROM $rasp_search as t WHERE t.transport_type != 'suburban' AND t.when != 'undefined');

    INSERT INTO @union_table
    SELECT
        unixtime as unixtime,
        fromId as from_id,
        toId as to_id,
        `when` as forward,
        IF(return_date == '', 'None', return_date) as backward,
        klass as klass,
        adult_seats as adult,
        children_seats as children,
        infant_seats as infant,
        national_version as national_version,
        lang as language,
        'portal' as source
    FROM $user_search
    UNION ALL
    SELECT
        `timestamp` as unixtime,
        from_id as from_id,
        to_id as to_id,
        IF(departure_date IS NULL, $current_date, departure_date) as forward,
        return_date as backward,
        'economy' as klass,
        CAST(String::SplitToList(Yson::ConvertToString(DictLookup(_rest, 'passengers_info')), ',')[0] as Int32) as adult,
        CAST(String::SplitToList(Yson::ConvertToString(DictLookup(_rest, 'passengers_info')), ',')[1] as Int32) as children,
        CAST(String::SplitToList(Yson::ConvertToString(DictLookup(_rest, 'passengers_info')), ',')[2] as Int32) as infant,
        tld as national_version,
        lang as language,
        'wizard' as source
    FROM $wizrd_search
    WHERE from_id IS NOT NULL and DictContains(_rest, 'passengers_info')
    UNION ALL
    SELECT
        `timestamp` as unixtime,
        from_id as from_id,
        to_id as to_id,
        IF(departure_date IS NULL, $current_date, departure_date) as forward,
        return_date as backward,
        'economy' as klass,
        1 as adult,
        0 as children,
        0 as infant,
        tld as national_version,
        lang as language,
        'wizard' as source
    FROM $wizrd_search
    WHERE from_id IS NOT NULL and NOT DictContains(_rest, 'passengers_info')
    UNION ALL
    SELECT
        CAST(unixtime AS Uint64) as unixtime,
        from_id as from_id,
        to_id as to_id,
        IF(`when` IS NULL, $current_date, `when`) as forward,
        IF(`return_date` == 'null', 'None', `return_date`) as backward,
        'economy' as klass,
        1 as adult,
        0 as children,
        0 as infant,
        national_version as national_version,
        'ru' as language,
        'rasp' as source
    FROM $rasp_search
    WHERE from_id IS NOT NULL
    ;
END DEFINE;

EVALUATE FOR $date IN $dates DO $check_one_day($date);

COMMIT;

$order_table = (select
    unixtime, from_id, to_id, forward, backward, klass, adult, children,infant,
    national_version, language, source
from @union_table WHERE forward >= CAST($start_day AS String) AND national_version = 'ru'
order by from_id, to_id, forward, backward, klass, adult, children, infant, national_version, unixtime);


$s = ($p) -> { return IF($p IS NULL, 'None', CAST($p as STRING)) };


$tmp = SELECT $s(from_id) || '_' || $s(to_id) || '_' || $s(forward) || '_' || $s(backward) || '_' || $s(klass) || '_' ||
        $s(adult) || '_' || $s(children) || '_' || $s(infant) || '_' || $s(national_version) as query_key,
        AsTuple(unixtime, source) AS timestamps_with_source
FROM $order_table
WHERE unixtime is not NULL;

INSERT INTO
    $cache_table
-- WITH TRUNCATE
SELECT query_key, CAST(ListSort(AGGREGATE_LIST(timestamps_with_source)) as List<Tuple<Uint64,String>>) as timeshots FROM $tmp
GROUP BY query_key;
