USE hahn;
DECLARE $cache_table as STRING;

$date_format = DateTime::Format("%Y-%m-%d %H:%M:%S");

$addMoscowTz =  ($unixTime) -> {
    RETURN $date_format(AddTimezone(DateTime::FromSeconds(cast($unixTime as UInt32)), 'Europe/Moscow'));
};

$GetSeconds = ($datetimeStr) -> {
    RETURN DateTime::ToSeconds(DateTime::MakeDatetime(DateTime::Parse("%Y-%m-%d %H:%M:%S")($datetimeStr)));
};

$ttlMinutes = ($reviewTime, $shownPriceUnixtime) -> {
    RETURN ($GetSeconds($reviewTime) - $GetSeconds($addMoscowTz($shownPriceUnixtime)))/60;
};


$total=(SELECT
    search_depth, ttl, COUNT(*) as total From (
    SELECT shown_result, review_time, shown_price_unixtime, search_depth
    FROM RANGE(`//home/logfeller/logs/avia-revise-log/1d`,`2020-04-22`,`2020-06-22`)
    WHERE
        wizard_redir_key IS not NULL
        and shown_result!='can_not_fetch_price_error'
        --$ttlMinutes(review_time, price_unixtime) > 60
    )
GROUP BY search_depth, (CASE WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=60 THEN '0-1'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>60 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=120 THEN '1-2'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>120 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=180 THEN '2-3'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>180 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=300 THEN '3-5'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>300 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=420 THEN '5-7'
     ELSE '7-999' END) as ttl
)
;
$problem=(SELECT
    search_depth,  ttl,  COUNT(*) as problem From (
    SELECT shown_result, review_time, shown_price_unixtime, search_depth
    FROM RANGE(`//home/logfeller/logs/avia-revise-log/1d`,`2020-04-22`,`2020-06-22`)
    where
        shown_result ='problem' and
        wizard_redir_key IS not NULL
        --and
        --$ttlMinutes(review_time, price_unixtime) > 60
    )
GROUP BY search_depth, (CASE WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=60 THEN '0-1'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>60 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=120 THEN '1-2'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>120 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=180 THEN '2-3'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>180 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=300 THEN '3-5'
     WHEN Math::Round($ttlMinutes(review_time, shown_price_unixtime))>300 and Math::Round($ttlMinutes(review_time, shown_price_unixtime))<=420 THEN '5-7'
     ELSE '7-999' END) as ttl
)
;

INSERT INTO
    $cache_table
WITH TRUNCATE
SELECT t.search_depth as search_depth, t.ttl as ttl_interval, p.problem as problem_cnt, t.total as total_cnt,  p.problem*1.0/t.total*100 as problem_share
from $total as t
join $problem as p
using (search_depth, ttl)
order by ttl_interval, search_depth
;