# -*- coding: utf-8 -*-
import argparse
from travel.avia.admin.lib.logs import print_log_to_stdout


class StdoutLogAction(argparse._StoreTrueAction):
    def __call__(self, parser, args, values, option_string=None):
        print_log_to_stdout()
        setattr(args, self.dest, values)


verbose_argument_parser = argparse.ArgumentParser()
verbose_argument_parser.add_argument('-v', '--verbose', action=StdoutLogAction)
