#!/bin/bash

set -e

old_make() {
    STANDALONE_PAGES="coach-schema validate"

    make -C markup YENV=production

    find markup -depth -name ".svn" -exec rm -rf \{\} \;

    for page in $STANDALONE_PAGES; do
        ycssjs --once=yes --minimize=yes --freeze=yes \
            markup/pages-desktop/$page/$page.css \
            markup/pages-desktop/$page/$page.ie*.css;
    done;
}

geoadmins_make() {
    (
        cd static/geoadmins;

        npm install
        # При сборке у нас fakeroot
        node_modules/.bin/bower --allow-root install
        node_modules/grunt-cli/bin/grunt -v dist

        for dir in common.blocks desktop.blocks desktop.bundles; do
            [ -d $dir ] && find $dir -regextype posix-extended \( \
                -regex ".*\.(gif|png|jpe?g|sfw|ico|svg|woff|ttf)" -o \
                -regex ".*/_[^/]*\.css" -o \
                -regex ".*/_[^/]*\.pub\.js" -o \
                -regex ".*/_[^/.]*\.js" \
                \) -exec install -D \{\} static/\{\} \;
        done
    );
}

old_make

find ./static/ \
    \( -name '*.css' -or -name '*.js' \) \
    -not \( -path './static/geoadmins*' -or -path './static/' \) \
    \
    | xargs -P 3 ycssjs --minimize=no

geoadmins_make
