# -*- coding: utf-8 -*-
import os.path

LOGGING_FORMAT = '%(name)s %(process)d %(asctime)s %(levelname)s: %(message)s'


def configure_logs(settings, log_path, tree_log_level='INFO'):
    # Подгружаем фиксы логирования для админки
    import travel.avia.admin.lib.logs  # noqa

    settings['LOG_FORMAT'] = LOGGING_FORMAT
    settings['LOG_COLLECTOR_FORMAT'] = u'%(levelname)s: %(message)s'
    settings['LOGGING_FORMAT'] = LOGGING_FORMAT
    settings['WARNING_LOG_PATH'] = os.path.join(log_path, 'warning.log')
    settings['ADMIN_LOG_PATH'] = os.path.join(log_path, 'admin.log')

    settings['LOGGING'] = {
        'version': 1,
        'disable_existing_loggers': False,
        'formatters': {
            'verbose': {
                '()': 'travel.avia.admin.lib.logs.ContextRaspFormatter',
                'format': LOGGING_FORMAT
            },
            'exception': {
                '()': 'ylog.ExceptionFormatter',
                'format': LOGGING_FORMAT,
            },
            'traceback': {
                '()': 'ylog.ExceptionFormatter',
                'format': LOGGING_FORMAT,
                'full': True,
                'show_locals': True
            },
        },
        'filters': {
            'require_debug_false': {
                '()': 'django.utils.log.RequireDebugFalse'
            },
            'exclude_from_tree': {
                '()': 'travel.avia.library.python.common.utils.logs.ExcludeFromTree',
                'starts_with_names': ('special.',),
                'exact_names': ('__main__',)  # Запуск скрипта нужно логировать lib.logs.create_current_file_run_log
            }
        },
        'handlers': {
            'sentry': {
                'level': 'ERROR',
                'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
            },
            'tree_handler': {
                'level': tree_log_level,
                'class': 'travel.avia.library.python.common.utils.logs.ArcadiaFileTreeHandler',
                'base_path': os.path.join(log_path, 'tree'),
                'formatter': 'verbose',
                'filters': ['exclude_from_tree'],
                'remove_prefix': 'travel.avia.admin',
            },
            'exception': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'exception.log'),
                'formatter': 'exception',
                'level': 'ERROR',
            },
            'traceback': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'traceback.log'),
                'formatter': 'traceback',
                'level': 'ERROR',
            },
            'py_warnings': {
                'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
                'filename': os.path.join(log_path, 'py_warnings.log'),
                'formatter': 'verbose',
                'level': tree_log_level,
            },
        },
        'loggers': {
            'django': {
                'handlers': ['exception', 'traceback'],
                'level': tree_log_level,
            },
            'py.warnings': {
                'handlers': ['py_warnings'],
                'level': tree_log_level,
            }
        },

        'root': {
            'handlers': ['tree_handler'] + (['sentry'] if settings.get('RAVEN_CONFIG') else []),
            'level': tree_log_level,
        }
    }

    if os.getenv('QLOUD_COMPONENT') is not None and os.getenv('QLOUD_LOGGER_STDERR_PARSER') == 'json':
        log_formatter = 'cloud_logger.formatters.QloudJsonFormatter'
    else:
        log_formatter = 'logging.Formatter'

    settings['LOGGING']['root']['handlers'].append('qloud_handler')
    for logger in settings['LOGGING']['loggers'].values():
        logger['handlers'].append('qloud_handler')
    settings['LOGGING']['formatters']['qloud'] = {
        '()': log_formatter,
        'format': '%(name)s: %(levelname)s %(asctime)s %(message)s',
        'datefmt': '%Y-%m-%d %H:%M:%S',
    }
    settings['LOGGING']['handlers']['qloud_handler'] = {
        'class': 'logging.StreamHandler',
        'formatter': 'qloud',
        'level': 'INFO',
    }

    if os.getenv('DISABLE_DJANGO_LOGGING_CONFIG', False):
        settings['LOGGING_CONFIG'] = None
