# -*- coding: utf-8 -*-

import re
import json

from travel.avia.library.python.common.models.currency import Price
from travel.avia.admin.lib.jinja import Library
from travel.avia.admin.www.templatetags.html import html


jinja = Library()


JS_REPLACE_RE = re.compile(ur'\$(\d\d?)', re.U)


@jinja.filter
def format_currency(price, info, selected=None, show_cents=True, from_=False, empty_value=u"-", wrapper=html.span(), unit=ur'$1'):
    if not price:
        return empty_value

    if not isinstance(price, Price):
        price = Price(price)

    price.rebase(info.rates)

    if not selected and hasattr(info, 'selected'):
        selected = info.selected

    if price.base_value is None or not selected:
        currency = price.currency
        value = price.value
    else:
        # currency = selected.code
        currency = selected
        value = price.base_value / info.rates[selected]
        # value = price.base_value / selected.rate

    result = info.formats[currency].format_value(
        value,
        show_cents=show_cents,
        format_unit=JS_REPLACE_RE.sub(u'{}', unit).format
    )

    if from_:
        result = u'от %s' % result

    element = wrapper()

    element.addClass('b-currency i-bem')

    params = {
        'b-currency': {
            'value': value,
            'currency': currency,
            'cents': show_cents,
            'from': bool(from_),
            'unit': unit,
            }
        }

    element.attr('onclick', 'return ' + json.dumps(params, ensure_ascii=False).replace('"', "'"))

    return element.html(result)
