# -*- coding: utf-8 -*-

from travel.avia.library.python.common.models.currency import Currency, Price
from travel.avia.library.python.common.models.geo import Settlement


class CurrencyInfo(object):
    def to_base(self, price):
        if not isinstance(price, Price):
            return price

        if price.currency not in self.rates:
            return None

        return price.value * self.rates[price.currency]

    def __json__(self):
        return self.json


def fetch_currency_info(request):
    currency_by_tld = {
        'ru': 'RUR',
        'by': 'BYR',
        'kz': 'KZT',
        'ua': 'UAH',
        'com.tr': 'TRY',
    }

    currencies = list(Currency.objects.all().order_by(Currency.L_order_field(request)))

    geoid = request.GET.get('geo_id') or getattr(request, 'geoid', None) or 213

    src, rates = Currency.fetch_rates(currencies, geoid)

    selected = None
    set_preferred = False

    selected_currency_code = request.GET.get('currency')

    if selected_currency_code in rates:
        selected = selected_currency_code
        set_preferred = True

    # Пробуем определить по кукие
    if not selected:
        preferred = request.COOKIES.get('preferredcurrency')

        if preferred in rates:
            selected = preferred

    # Если передан geoid, определяем по нему
    if not selected and request.GET.get('geo_id'):
        try:
            city = Settlement.objects.get(_geo_id=request.GET.get('geo_id'))

            if city.country:
                country_currency_id = city.country.currency_id

                for currency in currencies:
                    if currency.id == country_currency_id:
                        if currency.code in rates:
                            selected = currency.code

                        break

        except (Settlement.DoesNotExist, Settlement.MultipleObjectsReturned):
            pass

    # Пробуем определить по стране
    if not selected and request.client_city and request.client_city.country:
        country_currency_id = request.client_city.country.currency_id

        for currency in currencies:
            if currency.id == country_currency_id:
                if currency.code in rates:
                    selected = currency.code

                break

    # Пробуем определить по домену
    if not selected:
        try:
            selected = currency_by_tld[request.tld]
        except KeyError:
            pass

    # Если все обломалось, используем рубли
    if not selected or selected not in rates:
        selected = Currency.BASE_CURRENCY

    info = CurrencyInfo()

    info.source = src

    info.base = Currency.BASE_CURRENCY

    info.selected = selected

    info.country_base = 'RUR'

    if request.tld == 'com.tr':
        info.country_base = 'TRY'

    elif request.tld == 'ua':
        info.country_base = 'UAH'

    info.formats = {}

    info.currencies = []

    info.rates = rates

    for currency in currencies:
        info.formats[currency.code] = currency

        currency.rate = rates.get(currency.code)

        info.currencies.append(currency)

    info.order = [c.code for c in info.currencies]

    info.json = {
        'base': info.base,
        'country-base': info.country_base,
        'set-preferred': set_preferred,
        'selected': selected,
        'rates': rates,
        'order': info.order,
        'formats': dict((c.code, c.json()) for c in currencies),
        }

    return info
