from django.shortcuts import redirect
from django.core.urlresolvers import reverse

from travel.avia.admin.feature_flag_app.models import Service, FeatureFlag


def _by_code(model, request, code):
    service = model.objects.filter(code=code).first()
    if service is None:
        url = reverse(
            'admin:{}_{}_changelist'.format(
                model._meta.app_label,
                model._meta.model_name,
            )
        )

        return redirect(url)
    url = reverse(
        'admin:{}_{}_change'.format(
            model._meta.app_label,
            model._meta.model_name,
        ), args=[service.id]
    )

    return redirect(url)


def service_by_code(request, code):
    return _by_code(Service, request, code)


def feature_flag_by_code(request, code):
    return _by_code(FeatureFlag, request, code)
