import os
import sys
import codecs


preload_app = True
proc_name = 'avia-admin'

bind = os.getenv('BIND_ADDRESS')
workers = int(os.getenv('GUNICORN_WORKERS_COUNT', 4))

max_requests = int(os.getenv('GUNICORN_MAX_REQUESTS', 100))
max_requests_jitter = max_requests // 5

timeout = os.getenv('GUNICORN_TIMEOUT', 60)
graceful_timeout = timeout

limit_request_line = 8190


def post_fork(server, worker):
    from django.conf import settings

    stdout_path = os.path.join(settings.LOG_PATH, 'gunicorn_stdout.log')
    stderr_path = os.path.join(settings.LOG_PATH, 'gunicorn_stderr.log')

    sys.stdout = codecs.open(stdout_path, 'a', encoding='utf-8', errors='replace')
    sys.stderr = codecs.open(stderr_path, 'a', encoding='utf-8', errors='replace')


sys.stdout.flush()
sys.stderr.flush()
