# -*- coding: utf-8 -*-

import re


variable_re = re.compile(ur'{{\s+(?P<name>[a-zA-Z_]+)(\[(?P<form>.+?)\])?\s+}}')


def trans(format, **kwargs):
    def repl(m):
        name, form = m.group('name', 'form')

        arg = kwargs.get(name)

        if form:
            if hasattr(arg, 'form'):
                return arg.form(form)

        return unicode(arg)

    return variable_re.sub(repl, format)


def ntrans(pform0, pform1, pform2, num, **kwargs):
    # Скопировано из django_russian.utils.qnoun, но индексы форм
    # приведены в соответствие gettext

    # http://www.gnu.org/software/hello/manual/gettext/Plural-forms.html
    #          Plural-Forms: nplurals=3; \
    #           plural=n%10==1 && n%100!=11 ? 0 : \
    #                 n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;

    if num % 100 in [11, 12, 13, 14]:
        pform = pform2
    elif num % 10 == 1:
        pform = pform0
    elif num % 10 in [2, 3, 4]:
        pform = pform1
    else:
        pform = pform2

    return trans(pform, num=num, **kwargs)


def _test():
    class War:
        forms = {
            u'дат': u'войне',
            u'вин': u'войну',
            }

        def __unicode__(self):
            return u'война'

        def form(self, form):
            try:
                return self.forms[form]
            except KeyError:
                return unicode(self)

    war = War()

    print trans(u'Это — {{ war }}, {{ war[дат] }} — {{ war[вин] }}.', war=war)

    for n in [1, 23, 5]:
        print ntrans([u'{{ num }} мир', u'{{ num }} мира', u'{{ num }} миров'], n, war=u'Войны')

    for n in [1, 23, 5]:
        print ntrans([u'{{ num }} желтый{{ dot }}', u'{{ num }} желтых{{ dot }}'], n, dot='.')
