# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.common.utils.fields import CodeCharField, TrimmedCharField


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='LocaleForm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('language', CodeCharField(max_length=5, verbose_name='\u042f\u0437\u044b\u043a')),
                ('code', CodeCharField(max_length=10, null=True, verbose_name='\u041a\u043e\u0434')),
                ('desc', TrimmedCharField(default=b'', max_length=100, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'ordering': ('language', 'desc'),
                'verbose_name': '\u0424\u043e\u0440\u043c\u0430',
                'verbose_name_plural': '\u0424\u043e\u0440\u043c\u044b',
            },
        ),
        migrations.CreateModel(
            name='Localizable',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', TrimmedCharField(unique=True, max_length=255, verbose_name='\u0422\u0435\u043a\u0441\u0442')),
            ],
            options={
                'verbose_name': '\u0421\u0442\u0440\u043e\u043a\u0430',
                'verbose_name_plural': '\u0421\u0442\u0440\u043e\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='Localized',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', TrimmedCharField(max_length=255, verbose_name='\u0422\u0435\u043a\u0441\u0442')),
                ('form', models.ForeignKey(verbose_name='\u0424\u043e\u0440\u043c\u0430', to='i18n.LocaleForm')),
                ('localizable', models.ForeignKey(verbose_name='\u0421\u0442\u0440\u043e\u043a\u0430', to='i18n.Localizable')),
            ],
            options={
                'verbose_name': '\u041f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u043d\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430',
                'verbose_name_plural': '\u041f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='TestModel',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('s', models.ForeignKey(verbose_name='\u0421\u0442\u0440\u043e\u043a\u0430', to='i18n.Localized')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='localeform',
            unique_together=set([('code', 'language')]),
        ),
    ]
