# -*- coding: utf-8 -*-

from django.db import models

from travel.avia.library.python.common.utils.fields import TrimmedCharField, CodeCharField


class Localizable(models.Model):
    text = TrimmedCharField(u'Текст',
                            blank=False, null=False,
                            max_length=255, unique=True)

    def __unicode__(self):
        return self.text

    class Meta:
        verbose_name = u'Строка'
        verbose_name_plural = u'Строки'


class LocaleForm(models.Model):
    language = CodeCharField(u'Язык', max_length=5)
    code = CodeCharField(u'Код', max_length=10, null=True)
    desc = TrimmedCharField(u'Описание', max_length=100, default='', blank=True, null=False)

    def __unicode__(self):
        return u"%s: %s" % (self.language, self.desc)

    class Meta:
        unique_together = (('code', 'language'),)

        ordering = ('language', 'desc')

        verbose_name = u'Форма'
        verbose_name_plural = u'Формы'


class Localized(models.Model):
    localizable = models.ForeignKey(Localizable, verbose_name=u'Строка', null=False)
    form = models.ForeignKey(LocaleForm, verbose_name=u'Форма', null=False)
    text = TrimmedCharField(u'Текст', max_length=255, blank=False, null=False)

    class Meta:
        verbose_name = u'Переведенная строка'
        verbose_name_plural = u'Переведенные строки'


class TestModel(models.Model):
    s = models.ForeignKey(Localized, verbose_name=u'Строка')
