# -*- coding: utf-8 -*-

from urllib import quote
from django.conf import settings


def get_rasp_admin_url(object, relative_only=False):
    relative_url = u"/admin/%(app_label)s/%(module_name)s/%(object_id)s/" % {
        'app_label': object._meta.app_label,
        'module_name': object._meta.model_name,
        'object_id': quote(unicode(object.pk).encode('utf8'))
    }
    if relative_only:
        return relative_url
    else:
        return (u"https://%s" % (settings.ADMIN_DOMAIN_NAME or settings.DOMAIN_NAME)) + relative_url
