import logging

from django.conf import settings

from blackbox import XmlBlackbox, FIELD_LOGIN, BlackboxError

from travel.avia.admin.lib.exceptions import InternalError
from travel.library.python.tvm_ticket_provider import provider_fabric


_blackbox = XmlBlackbox(
    url=settings.YANDEX_BLACKBOX_URL,
)


_tvm_client = provider_fabric.create(settings)


logger = logging.getLogger(__name__)


class AuthError(Exception):
    def __init__(self, msg):
        super(AuthError, self).__init__(self)
        self.msg = msg


def get_user_by_token(token, user_ip):
    headers = {'Authorization': token}
    ticket = _tvm_client.get_ticket(settings.EXTERNAL_BLACKBOX_TVM_NAME)
    if ticket:
        headers['X-Ya-Service-Ticket'] = ticket
    try:
        data = _blackbox.oauth(
            userip=user_ip,
            headers_or_token=headers,
            dbfields=[FIELD_LOGIN],
            by_token=False,
        )

    except BlackboxError as exc:
        logger.error('Blackbox: %s', exc)
        raise InternalError()

    if data['status'] != 'VALID':
        raise AuthError('Invalid token')

    scope = data['oauth']['scope']
    if 'avia_partner:read' not in scope.split():
        raise AuthError('Bad scope: {}'.format(scope))

    if data.get('valid', False):
        return data['uid']

    return None
