# -*- mode: python; coding: utf-8 -*-

import MySQLdb


def connect_to_replica(replica, db_name, **kwargs):
    from django.conf import settings
    from django.utils.safestring import SafeString, SafeUnicode

    from travel.avia.library.python.common.utils.mysql_switcher.base import rasp_conversions, CONNECT_OPTIONS

    default_settings_dict = settings.DATABASES['default']

    default_kwargs = {
        'use_unicode': False,
        'conv': rasp_conversions,
    }

    default_kwargs.update(CONNECT_OPTIONS)

    default_kwargs['connect_timeout'] = 10
    default_kwargs['read_timeout'] = 10
    default_kwargs['write_timeout'] = 10

    if default_settings_dict['USER']:
        default_kwargs['user'] = default_settings_dict['USER']

    if default_settings_dict['PASSWORD']:
        default_kwargs['passwd'] = default_settings_dict['PASSWORD']

    if default_settings_dict['PORT']:
        default_kwargs['port'] = int(default_settings_dict['PORT'])

    default_kwargs['host'] = replica.host
    default_kwargs['db'] = db_name

    default_kwargs.update(kwargs)
    kwargs = default_kwargs

    connection = MySQLdb.connect(**kwargs)

    connection.encoders[SafeUnicode] = connection.encoders[unicode]
    connection.encoders[SafeString] = connection.encoders[str]

    return connection
