def compute_coverage(points, window_size):
    """
    Compute a total length of segments [p; p + @windows_size] for p in @points
    """

    points = sorted(points)
    left_border = points[0]
    right_border = points[0] + window_size
    coverage = type(window_size)(0)  # We want to use this function with different types

    for point in points:
        if point > right_border:
            coverage += right_border - left_border
            left_border = point

        right_border = point + window_size

    coverage += right_border - left_border

    return coverage
