# -*- coding: utf-8 -*-

from contextlib import closing

import requests
from django.conf import settings


def download_file(url, filepath, chunk_size=1024, auth=None, verify=False):
    """
    http://stackoverflow.com/questions/16694907/how-to-download-large-file-in-python-with-requests-py
    """

    # stream=True for less memory usage
    with closing(requests.get(url, stream=True, timeout=settings.SCHEDULE_IMPORT_TIMEOUT,
                              auth=auth, verify=verify)) as r:
        with open(filepath, 'wb') as f:
            for chunk in r.iter_content(chunk_size=chunk_size):
                if chunk:  # filter out keep-alive new chunks
                    f.write(chunk)
    return filepath
