# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from travel.avia.admin.feature_flag_app.models import FeatureFlag


def new_pricing_flag_name_by_partner_code(partner_code):
    return 'AVIA_PRICING_2019_{}'.format(partner_code.upper())


def extended_report_flag_name_by_partner_code(partner_code):
    return 'AVIA_EXTENDED_REPORT_{}'.format(partner_code.upper())


def _get_feature_flag_value(flag_name):
    try:
        enabled = FeatureFlag.objects.get(code=flag_name).enabled
    except FeatureFlag.DoesNotExist:
        return False
    else:
        # В админке не может быть AB, поэтому для FeatureFlag.USE_AB считаем, что флаг выключен
        return enabled == FeatureFlag.ENABLED


def new_pricing_flag_by_partner_code(partner_code):
    flag_name = new_pricing_flag_name_by_partner_code(partner_code)
    return _get_feature_flag_value(flag_name)


def extended_report_flag_by_partner_code(partner_code):
    flag_name = extended_report_flag_name_by_partner_code(partner_code)
    return _get_feature_flag_value(flag_name)
