# -*- coding: utf-8 -*-
from django.db.models import Q

from travel.avia.library.python.common.models.geo import Settlement, Station
from travel.avia.library.python.common.models.schedule import Company
from travel.avia.library.python.common.models.transport import TransportType


airline_cache = {}


def company_by_code(code, log):
    if code not in airline_cache:
        if code == 'FV':
            try:
                airline = Company.objects.get(
                    t_type_id=TransportType.PLANE_ID, title="Россия"
                )
            except Company.DoesNotExist:
                log.warning('Can\'t find FV airline')
                airline = None
        else:
            airline = Company.objects.filter(
                Q(iata=code) | Q(sirena_id=code)
            ).order_by(
                '-priority'
            ).first()

        if not airline:
            log.warning('Bad airline code: %s', code)

        airline_cache[code] = airline
    else:
        airline = airline_cache[code]

    if not airline:
        raise BadCompanyIATA

    return airline


def cache_codes():
    cache = {}

    def update_cache(code, point):
        if code:
            cache[code] = point

    for station in Station.objects.filter(t_type__code='plane', hidden=False):
        update_cache(station.iata, station)
        update_cache(station.icao, station)

    for settlement in Settlement.objects.filter(hidden=False):
        update_cache(settlement.iata, settlement)

    return cache


def make_points(point):
    station = None
    settlement = None

    if isinstance(point, Station):
        station = point
        settlement = station.settlement

    if isinstance(point, Settlement):
        settlement = point
        airports = settlement.get_all_iata_airports()

        if airports and len(airports) == 1:
            station = airports[0]

    return settlement, station


class BadCompanyIATA(Exception):
    pass
