# -*- coding: utf-8 -*-

from django import forms


class SuggestWidget(forms.TextInput):
    def __init__(self, *args, **kwargs):
        self.suggest = kwargs.pop('suggest')

        super(SuggestWidget, self).__init__(*args, **kwargs)

    def render(self, name, value, attrs=None):
        return """<span class="js-suggest {suggests: '%s'}">%s</span>""" % (self.suggest, super(SuggestWidget, self).render(name, value, attrs))
