# -*- coding: utf-8 -*-
from collections import defaultdict
from operator import itemgetter


def group_tree_named(items, path):
    if not path:
        return items
    if isinstance(path, basestring):
        path = path.split('.')
    levelname = path[0]
    level = groupby(itemgetter(levelname), items)
    for k, v in level.items():
        level[k] = group_tree_named(v, path[1:])
    return {levelname: level}


def group_tree(items, path):
    if not path:
        return items
    if isinstance(path, basestring):
        path = path.split('.')
    level = groupby(itemgetter(path[0]), items)
    for k, v in level.items():
        level[k] = group_tree(v, path[1:])
    return level


def groupby(key, items):
    grouped = defaultdict(list)
    for item in items:
        grouped[key(item)].append(item)
    return dict(grouped)
