import logging
import socket


logger = logging.getLogger(__name__)


def get_ipv6_addresses_by_hostname(hostname):
    addrinfo = socket.getaddrinfo(hostname, None, socket.AF_INET6)
    hosts = {
        info[4][0]
        for info in addrinfo
    }

    logger.info('DNS response: %r', hosts)
    for host in hosts:
        yield host
