import logging

from travel.avia.library.python.common.models.partner import PartnerUser, Partner

from travel.avia.admin.lib.auth import get_user_by_token


logger = logging.getLogger(__name__)


def get_partner_puids(billing_client_id):
    return Partner.objects.get(
        billing_client_id=billing_client_id
    ).partner_users.values_list('passportuid', flat=True)


def check_is_staff(puid):
    return puid in PartnerUser.objects.filter(role__in=['admin', 'manager']).values_list('passportuid', flat=True)


def check_access_to_report(billing_client_id, token, user_ip):
    # type: (int, str, str) -> bool
    if not token:
        # We do not provide unathorized access
        return False

    puid_from_token = get_user_by_token(token, user_ip)
    partner_puids = get_partner_puids(billing_client_id)

    if puid_from_token in partner_puids:
        return True

    return check_is_staff(puid_from_token)
