# -*- coding: utf8 -*-
import logging

from django.conf import settings
from django.utils.html import escape


from travel.avia.library.python.common.models.partner import PartnerEmail
from travel.avia.library.python.common.utils import environment
from travel.avia.library.python.common.lib.mail import SmailikClient

DEFAULT_NOTIFY_BALANCE_THRESHOLD = 300
try_send_all_anyway = False
send_reminder_if_not = False

log = logging.getLogger(__name__)


LOW_BALANCE_NOTIFICATION_MAIL_TYPE = 'low_balance_notification'
NONPOSTIVE_BALANCE_NOTIFICATION_MAIL_TYPE = 'nonpositive_balance_notification'
POSTIVE_BALANCE_NOTIFICATION_MAIL_TYPE = 'positive_balance_notification'
STATISTIC_REMINDER_NOTIFICATION_MAIL_TYPE = 'statistic_reminder_notification'
MAILS = {
    LOW_BALANCE_NOTIFICATION_MAIL_TYPE: {
        'subject': u"Ваш баланс в Яндекс.Авиабилетах близок к нулю",
        'message': u"""
Здравствуйте.<br />
Ваш баланс {current_balance:.2f} у.е.<br />
При нулевом или отрицательном балансе ваши предложения перестанут показываться на сервисе Яндекс.Авиабилеты.
Советуем Вам пополнить баланс.<br />
<br />
По всем вопросам просьба писать на avia-info@yandex-team.ru<br />
--<br />
Яндекс.Авиабилеты<br />
"""},

    NONPOSTIVE_BALANCE_NOTIFICATION_MAIL_TYPE: {
        'subject': u"Яндекс.Авиабилеты: нулевой баланс",
        'message': u"""
Здравствуйте.<br />
Ваш баланс на {current_datetime} составляет 0 у.е.<br />
В настоящее время Ваши предложения не отображаются на сервисе Яндекс.Авиабилеты.
После пополнения баланса кампания автоматически возобновится.<br />
По всем вопросам просьба писать на avia-info@yandex-team.ru<br />
--<br />
Яндекс.Авиабилеты<br />
"""
    },
    POSTIVE_BALANCE_NOTIFICATION_MAIL_TYPE: {
        'subject': u"Яндекс.Авиабилеты: пополнение баланса",
        'message': u"""
Здравствуйте.<br />
Ваш баланс на {current_datetime} составляет {current_balance:.2f} у.е.<br />
Ваши предложения снова отображаются на сервисе Яндекс.Авиабилеты.<br />
По всем вопросам просьба писать на avia-info@yandex-team.ru<br />
--<br />
Яндекс.Авиабилеты<br />
"""
    },
    STATISTIC_REMINDER_NOTIFICATION_MAIL_TYPE: {
        'subject': u"Яндекс.Авиабилеты: статистика продаж",
        'message': u"""
Здравствуйте.<br />
Напоминаем Вам, что, согласно договору, Вам необходимо в течение 5 рабочих дней с момента окончания
отчетного месяца предоставить нам статистику по количеству и общей стоимости приобретенных пользователями
авиабилетов в результате их перехода с сервиса Яндекс.Авиабилеты. Просим прислать эти данные за прошедший
месяц на адрес avia-info@yandex-team.ru.<br />
Спасибо.<br />
По всем вопросам просьба писать на avia-info@yandex-team.ru<br />
--<br />
Яндекс.Авиабилеты<br />
"""
    }
}


def send_mail(partner, mail_type):
    """
    Отправляем письмо партнерам
    """
    if mail_type not in MAILS:
        log.error('Unknow mail\'s type: %s', mail_type)
        return False

    mail = MAILS[mail_type]
    subject = mail['subject']
    message = mail['message'].format(
        current_balance=partner.current_balance,
        current_datetime=environment.now().strftime(u"%Y-%m-%d %H:%M")
    )

    to_emails = [pe.email.strip() for pe in PartnerEmail.objects.filter(emailtype__code='base', partner=partner)]

    if not to_emails:
        log.info('*** No base emails for %s. Skip sending.', partner.code)
        return False

    if not settings.SEND_MAIL_TO_PARTNERS:
        subject = ("Test to %s: " % partner.code) + subject
        to_emails = ['avia-partnerstat-copy-test@yandex-team.ru']

    bcc_ = u'avia-partnerstat-copy@yandex-team.ru'

    c = SmailikClient(
        service='Flights.Yandex',
        send_from=u'Яндекс.Авиабилеты &lt;avia-partner@support.yandex.ru&gt;',
        reply_to=u'Яндекс.Авиабилеты &lt;avia-info@yandex-team.ru&gt;',
        smailik_dir='/var/spool/smailik-preparer/avia-stats/'
    )

    for to_email in to_emails:
        log.info(
            u'*** Send message to: {to}, bcc: {bcc}'.format(
                to=to_email, bcc=bcc_
            )
        )

        c.send_email(
            to_email,
            escape(subject),
            message,
            bcc=bcc_
        )

    return True
