# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from travel.avia.library.python.common.models.partner import RedirectType


class RedirectTypePicker(object):
    def __init__(self):
        self.redirect_type_by_code = {rt.code: rt for rt in RedirectType.objects.all()}

    def get_from_balance_log(self, record):
        if record['UTM_SOURCE'] == 'rasp' and record['UTM_MEDIUM'] == 'redirect':
            return self.redirect_type_by_code['direct_rasp']

        if record['UTM_SOURCE'] == 'sovetnik' and record['UTM_CONTENT'] == 'redirect':
            return self.redirect_type_by_code['direct_sovetnik']

        if record['UTM_SOURCE'] == 'wizard_ru' or record['UTM_SOURCE'] == 'unisearch_ru':
            if record['WIZARDREDIRKEY']:  # == UNISEARCHREDIRKEY
                return self.redirect_type_by_code['direct_wizard']
            else:
                return self.redirect_type_by_code['indirect_wizard']

        return self.redirect_type_by_code['inderect']

    def get_by_code(self, redirect_type):
        code = redirect_type
        if redirect_type == 'indirect':
            code = 'inderect'
        return self.redirect_type_by_code.get(code)
