# -*- coding: utf-8 -*-
from contextlib import contextmanager
from subprocess import Popen, PIPE
from travel.avia.admin.lib import tmpfiles
from travel.avia.library.python.common.utils.unicode_csv import UnicodeDictReader
import os


def get_process_name(pid):
    pass


def get_ps_aux_lines():
    ps = Popen(["ps", "aux"], stdout=PIPE)
    ps_result = ps.communicate()[0].split("\n")
    return [line for line in ps_result]


def get_ps_ax_dicts():
    ps = Popen(["ps", "ax", "-o", "%p;%u;%a"], stdout=PIPE)
    ps_result = ps.communicate()[0].split("\n")
    return [rowdict for rowdict in UnicodeDictReader(ps_result, delimiter=";", strip_values=True, strip_keys=True)]


def get_current_process_command():
    processes = get_ps_ax_dicts()
    current_process = [r for r in processes if r['PID'] == str(os.getpid())][0]

    return current_process['COMMAND']


@contextmanager
def child_finalizer():
    try:
        yield
    except SystemExit as e:
        tmpfiles.clean()
        if e.code != 0:
            os._exit(1)
        else:
            os._exit(0)
    finally:
        os._exit(0)
