# -*- coding: utf8 -*-
import os


class EnvironmentDetector(object):
    """
    Определяем в каком окружнии запущенно приложение
    """
    available_types = {'development', 'stress', 'testing', 'production'}

    def get_environment_type(self):
        # type: () -> str
        file_name = '/etc/yandex/environment.type'
        environment_type = None
        if os.path.exists(file_name):
            with open(file_name, 'r') as f:
                environment_type = f.read().strip()
        if environment_type not in EnvironmentDetector.available_types:
            environment_type = None
        return environment_type


environment_detector = EnvironmentDetector()
