# -*- coding: utf8 -*-
from collections import defaultdict

from travel.avia.library.python.common.models.scripts import ScriptResult


class ScriptResultCleaner(object):
    def __init__(self, max_count=1000):
        self._max_count = max_count

    def clean(self):
        # type: () -> None
        results = (
            ScriptResult.objects
            .all()
            .order_by('-started_at')
            .values_list('id', 'script_id')
        )

        scripts_to_count = defaultdict(int)
        removes = []
        for result_id, script_id in results:
            scripts_to_count[script_id] += 1
            if scripts_to_count[script_id] > self._max_count:
                removes.append(result_id)

        ScriptResult.objects.filter(id__in=removes).delete()


script_result_cleaner = ScriptResultCleaner()
