# -*- coding: utf8 -*-
import os
import logging

from django.conf import settings

from travel.avia.library.python.common.utils import environment
from travel.avia.admin.lib.logs import ContextRaspFormatter


class ScriptRunLoggerFactory(object):
    """
    Создаем логгер, который будет писать в определенный файл все логи
    """
    def __init__(self, environment):
        self._environment = environment

    def create(self, script_code, log_format='', prefix='special.script_runs'):
        # type: (str, str, str) -> str
        log_name = '{}.{}'.format(prefix, script_code)

        path = os.path.join(settings.LOG_PATH, *log_name.split('.'))
        path = os.path.join(path, self._environment.now().strftime('%Y-%m-%d_%H%M%S.log'))

        if not os.path.exists(os.path.dirname(path)):
            os.makedirs(os.path.dirname(path))

        handler = logging.FileHandler(path)
        handler.setFormatter(ContextRaspFormatter(log_format or settings.LOG_FORMAT))

        log = logging.getLogger()
        log.addHandler(handler)

        return path


script_run_logger_factory = ScriptRunLoggerFactory(environment)
