from django.db.models import Q

from travel.avia.library.python.common.models.geo import Settlement, StationCode


settlements_cache = {}


def get_settlement(iata):
    if iata not in settlements_cache:
        settlement = None

        try:
            settlement = Settlement.objects.get(iata=iata)

        except Settlement.DoesNotExist:
            pass

        if not settlement:
            try:
                station = StationCode.objects.get(
                    Q(system__code__iexact='iata') | Q(system__code__iexact='sirena'),
                    code__iexact=iata
                )
                settlement = station.station.settlement

            except StationCode.DoesNotExist:
                pass

        settlements_cache[iata] = settlement

    return settlements_cache[iata]
