import statface_client
from django.conf import settings


def _get_client(beta):
    if beta:
        return statface_client.BetaStatfaceClient(oauth_token=settings.STATFACE_TOKEN)
    else:
        return statface_client.ProductionStatfaceClient(oauth_token=settings.STATFACE_TOKEN)


def post_data_to_stat(name, data, scale='d', beta=False, _append_mode=1, raw_data=False):
    """data is dict of values :
    data = [
                {'fielddate': '2015-02-03', 'project': 'Portal', 'name': '400', 'field1': 99},
                {'fielddate': '2015-02-03', 'project': 'Morda', 'name': '400', 'field1': 30},
                {'fielddate': '2015-02-04', 'project': 'Portal', 'name': '400', 'field1': 19},
                {'fielddate': '2015-02-04', 'project': 'Morda', 'name': '400', 'field1': 102},
            ]
    """
    if _append_mode and not data:
        return

    report = _get_client(beta).get_report(name)

    return report.upload_data(
        scale=scale,
        format='json',
        _append_mode=_append_mode,
        data='{"values":{}}'.format(data) if raw_data else data,  # noqa
    )
