# -*- coding: utf-8 -*-

NSMAP = {'ns2': 'http://www.agent.ru/ws/booking/extended/v1/'}


class Classifiers(object):
    def __init__(self):
        self.companies = {}
        self.airports = {}
        self.planes = {}
        self.cities = {}


class TabloClassifiers(object):
    def __init__(self):
        self.companies = {}
        self.sirena_airports = {}
        self.planes = {}
        self.icao_airports = {}
        self.iata_airports = {}
        self.name_airports = {}


def parse_classifiers(tree):
    cl = Classifiers()

    for company in tree.xpath('.//ns2:aircompany', namespaces=NSMAP):
        company_code = get_element_text(company, 'iataCode') or get_element_text(company, 'code')

        cl.companies[get_element_text(company, 'refId')] = company_code

    for airport in tree.xpath('.//ns2:airport', namespaces=NSMAP):
        cl.airports[get_element_text(airport, 'refId')] = get_element_text(airport, 'iataCode')

    for city in tree.xpath('.//ns2:city', namespaces=NSMAP):
        cl.cities[get_element_text(city, 'refId')] = get_element_text(city, 'iataCode')

    for plane in tree.xpath('.//ns2:plane', namespaces=NSMAP):
        cl.planes[get_element_text(plane, 'refId')] = plane.xpath('.//ns2:name/ns2:name', namespaces=NSMAP)[0].text

    return cl


def parse_tablo_classifiers(tree):
    cl = TabloClassifiers()

    for airport in tree.xpath('.//ns2:airport', namespaces=NSMAP):
        cl.sirena_airports[get_element_text(airport, 'refId')] = get_element_text(airport, 'code')
        cl.iata_airports[get_element_text(airport, 'refId')] = get_element_text(airport, 'iataCode')
        cl.icao_airports[get_element_text(airport, 'refId')] = get_element_text(airport, 'icaoCode')
        cl.name_airports[get_element_text(airport, 'refId')] = airport.xpath('.//ns2:name/ns2:name', namespaces=NSMAP)[0].text

    for company in tree.xpath('.//ns2:aircompany', namespaces=NSMAP):
        company_code = get_element_text(company, 'iataCode') or get_element_text(company, 'code')

        cl.companies[get_element_text(company, 'refId')] = company_code

    return cl


def get_element_text(parent, name):
    e = parent.xpath('.//ns2:%s' % name, namespaces=NSMAP)

    if len(e):
        return e[0].text and e[0].text.strip()
    else:
        return None
