# -*- coding: utf-8 -*-

from django.conf import settings
from django.utils.functional import lazy

if getattr(settings, 'DEBUG_I18N', False):
    from travel.avia.admin.www.utils.data import rus2translit as ugettext
else:
    from django.utils.translation import ugettext


# For jinja
def gettext(s):
    return ugettext(s)


def _format(text, *args):
    # lazy проксирует __mod__, по этому для lazy_unicode тоже все будет работать
    return text % args


lazy_format = lazy(_format, unicode)
